<?php

include_once 'conexao.php'; 
  
class ModeloComentario
{  
	static public function mdlAddComentario($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO cometario (idVaga,idTema,idMateria,comentario,idUsuario,dataComentario) VALUES 
						(:idVaga,:idTema,:idMateria,:comentario,:idUsuario,:dataComentario)");
		$stmt->bindParam(":idVaga", $dados["idVaga"], PDO::PARAM_STR);
		$stmt->bindParam(":idTema", $dados["idTema"], PDO::PARAM_STR);
		$stmt->bindParam(":idMateria", $dados["idMateria"], PDO::PARAM_STR);
		$stmt->bindParam(":comentario", $dados["comentario"], PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $dados["idUsuario"], PDO::PARAM_STR);
		$stmt->bindParam(":dataComentario", $dados["dataComentario"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}

	static public function mdlMostrarTodosComentarioPorIdDoEvento($idVaga) {

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM cometario where idVaga = :idVaga ORDER BY idComentario desc Limit 3");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosComentarioDaVagaPorIdDoEvento($idVaga, $idTema, $idMateria) {

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM cometario where idVaga = :idVaga and idTema = :idTema and idMateria = :idMateria ORDER BY idComentario desc Limit 3");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
			$stmt->bindParam(":idMateria", $idMateria, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosComentarioDestaParteDaMateriaPorIdMateria($idMateria) {

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("SELECT * FROM cometario where idMateria = :idMateria ORDER BY idComentario desc Limit 3");
		$stmt->bindParam(":idMateria", $idMateria, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlMostrarComentarioPorIdDoEventoComLimite($idVaga,$limit) {

		$resultado = array();

		$stmt = Conexao::conectar()->prepare("SELECT * FROM cometario where idVaga = :idVaga order by idComentario desc Limit :limit ");
		$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":limit", $limit, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}




}



?>